
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   SENDNMEA.C - NMEA Send Message Processing
// 
//
//   DESCRIPTION
//
//   Functions to send NMEA-0183 messages to the receiver.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\SENDNMEA.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:10   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:16:20   COLEJ
//   Multiple Changes...
//   
//      Rev 1.2   Feb 12 1997 16:05:54   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:10:22   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:24   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <bios.h>
#include <stdlib.h>
#include <graph.h>
#include <conio.h>
#include <ctype.h>
#include <string.h>
#include <math.h>
#include <dos.h>

#ifdef __WATCOMC__
#define _strnset strnset
#endif

#include "LABMON.H"
#include "DISPLAY.H"
#include "MONMISC.H"
#include "SENDNMEA.H"

extern char nmea_msg[80];

extern short  cmdline; 
extern long cntcom, cntdgp, cntinit, cntlog, cntq, cntgen, cntilog, cntibit;
extern short TERMINAL;

void send_nmea_q(void)
{
   short valid;

   // build the message
   clear_message_line();  
   strcpy(nmea_msg, "$IIGPQ,");
   ask_str("MESSAGE ID TO QUERY (XXX)-> ", nmea_msg+7, &valid);
   clear_message_line();  
   if(!valid) return;
   
   // send the message 
   cntq++;
   if(TERMINAL) clear_screen();
   send_nmea_msg(nmea_msg);
} 

void send_nmea_gen(void)
{
   short valid;

   // build the generic message
   clear_message_line();  
   _strnset(nmea_msg, ' ', 80);
   nmea_msg[0] = '$';
   nmea_msg[79] = '\0';
   ask_str("$", nmea_msg+1, &valid); 
   if(!valid) return;
   
   // send the message
   cntgen++;
   send_nmea_msg(nmea_msg);
} 

void send_nmea_log(void)
{
   char  MsgID[3]    = " ";
   char  MsgEnable   = 'A';
   short MsgInterval =   1;
   short valid;

   // build the message
   clear_message_line();
   ask_str("MESSAGE ID (XXX, ??? DISABLES ALL) -> ", MsgID, &valid);
   clear_message_line(); 
   if(!valid) return;
   MsgEnable = ask_char("ENABLE FLAG (A=ENABLE, V=DISABLE) -> ", MsgEnable, &valid);
   clear_message_line();   
   if(!valid) return;
   MsgInterval = ask_short("MESSAGE INTERVAL (SEC) -> ", MsgInterval, &valid);
   clear_message_line();                                  
   if(!valid) return;
   if(strcmp(MsgID, "???")){
      sprintf(nmea_msg,"$PRWILOG,%s,%c,%i", MsgID, MsgEnable, MsgInterval);
   }
   else{
      sprintf(nmea_msg,"$PRWILOG,%s,V,", MsgID);
   }   
   // send the message 
   cntlog++;
   if(TERMINAL) clear_screen();  
   send_nmea_msg(nmea_msg);
}

void send_nmea_ilog(void)
{
   char ctemp;
   char MsgID[3]    = " ";
   char MsgEnable;
   char MsgTrigger;
   short  MsgInterval;
   short  MsgOffset;
   short  valid;

   // build the message
   clear_message_line();
   ask_str("MESSAGE ID (XXX, ??? DISABLES ALL) -> ", MsgID, &valid);
   clear_message_line();  
   if(!valid) return;

   if (!strcmp(MsgID, "???")) {  // disable all message outputs

      strcpy(nmea_msg,"$PRWIILOG,???,V,,,");
   }

   else{  // normal log request

      ctemp = ask_char("LOG (C=CONNECT, D=DISCONNECT, N=NO CHANGE) -> ", 'N', &valid);
      clear_message_line();
      if (!valid) return;
      if (toupper(ctemp) == 'C'){
         MsgEnable = 'A';  // connect
      }
      else if(toupper(ctemp) == 'D'){
         MsgEnable = 'V';  // disconnect
      }

      ctemp = ask_char("MODIFY TIMING? (Y,N) -> ", 'N', &valid);
      clear_message_line();
      if (!valid) return;

      if (toupper(ctemp) == 'Y'){  // on time

         MsgTrigger = ask_char("MESSAGE TRIGGER (T=TIME, U=UPDATE) -> ", 'T', &valid);
         clear_message_line();
         if(!valid) return;

         if (toupper(MsgTrigger) == 'T'){
            MsgInterval = ask_short("MESSAGE INTERVAL (SECS) -> ", 1, &valid);
            clear_message_line();
            if(!valid) return;

            MsgOffset = ask_short("MESSAGE OFFSET (SECS) -> ", 0, &valid);
            clear_message_line();
            if(!valid) return;
         }
         else if (toupper(MsgTrigger) == 'U'){
            MsgInterval = 0;  // on update, these should be zero
            MsgOffset   = 0;
         }
         else return; // invalid trigger

         sprintf(nmea_msg,"$PRWIILOG,%s,%c,%c,%i,%i", MsgID, MsgEnable,
                 MsgTrigger, MsgInterval, MsgOffset);
      }
      
      else{  // don't modify timing

         sprintf(nmea_msg,"$PRWIILOG,%s,%c,,,", MsgID, MsgEnable);
      }
   }

   // send the message 
   cntlog++;
   if(TERMINAL) clear_screen();  
   send_nmea_msg(nmea_msg);
} 

void send_nmea_typ(void)
{
   // build the messages and send
   sprintf(nmea_msg,"$PRWILOG,GLL,A,1");
   cntlog++; 
   send_nmea_msg(nmea_msg); 
   sprintf(nmea_msg,"$PRWILOG,GSV,A,1");
   cntlog++;  
   send_nmea_msg(nmea_msg);
   sprintf(nmea_msg,"$PRWILOG,RMC,A,1");
   cntlog++;  
   send_nmea_msg(nmea_msg);
   sprintf(nmea_msg,"$PRWILOG,GSA,A,1");
   cntlog++;
   send_nmea_msg(nmea_msg);
  // sprintf(nmea_msg,"$PRWILOG,ALT,A,1");
  // cntlog++;  
  // send_nmea_msg(nmea_msg);
   sprintf(nmea_msg,"$PRWILOG,COM,A,0");
   cntlog++;  
   send_nmea_msg(nmea_msg);
   sprintf(nmea_msg,"$PRWILOG,ZDA,A,0");
   cntlog++;  
   send_nmea_msg(nmea_msg);
} 

void send_nmea_ityp(void)
{
   // build the messages and send
   sprintf(nmea_msg,"$PRWIILOG,RID,A,T,0,0");
   cntilog++;  
   send_nmea_msg(nmea_msg);  
   sprintf(nmea_msg,"$PRWIILOG,GGA,A,T,1,0");
   cntilog++; 
   send_nmea_msg(nmea_msg); 
   sprintf(nmea_msg,"$PRWIILOG,GSA,A,T,1,0");
   cntilog++;  
   send_nmea_msg(nmea_msg);
   sprintf(nmea_msg,"$PRWIILOG,GSV,A,T,2,0");
   cntilog++;  
   send_nmea_msg(nmea_msg);
   sprintf(nmea_msg,"$PRWIILOG,RMC,A,T,1,0");
   cntilog++;
   send_nmea_msg(nmea_msg);
   sprintf(nmea_msg,"$PRWIILOG,ZCH,A,T,1,0");
   cntilog++;
   send_nmea_msg(nmea_msg);
} 

void send_nmea_msg(BYTE *msg)  
{  
   // sends message while ignoring receive buffer
    
   short i;
   short len; 
   short cs;
   char  buff[80];
  
   // determine the number of bytes and compute checksum 
   len = strlen(msg); 
   _strupr(msg);
   cs = 0L;//l;
   for(i=1; i<len; i++){
      cs ^= (short) *(msg+i); 
   }
   sprintf(buff, "%02hx", cs);
   msg[len]   = '*';
   msg[++len] = buff[0];
   msg[++len] = buff[1];  
   
   // terminate message   
   msg[++len] = '\x0D';   
   msg[++len] = '\x0A';
   msg[++len] = '\0';

   // convert to upper case and send the message
   _strupr(msg);
   for(i=0;i<len;i++){
      send_byte(msg[i]);
   }   
   
   // acknowledge nmea message and echo it
   _settextposition(MSGR,MSGC);
   _outtext("NMEA SENT");
   clear_message_line();  
   msg[len-2] = '\0';
   _outtext(msg);

   // update the message counters if menu if off 
   if(!menu_on){
      show_count();
   }
}       
